



/**
 ******************************************************************************
 *
 * @file        USBD_DSC.c
 * @brief       The USBD Descriptor's c file.
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2024/10/04
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

#include "MG32.h"
#include "MG32_USBD_EasyPODMini.h"


// <<< Use Configuration Wizard in Context Menu >>>

//<h> USB Descriptor
    //<h> Device Descriptor
        //<o0> USB specification release number<0x0000-0xFFFF>
        //<i> 0x0110 = USB 1.1
				//<i> 0x0200 = USB 2.0
				//<i> 0x0210 = USB 2.1
        #define dcdUSB                       0x0110
        //<o0> Device Class <0x00=> Use class code info from Interface Descriptors
				//                  <0x02=> Communications and CDC Control
				//                  
				#define bDeviceClass                 0x00
				//<o0> Subclass  <0x00-0xFF>
				#define bDeviceSubClass              0x00
				//<o0> Protocol  <0x00-0xFF>
				#define bDeviceProtocol              0x00
        
        //<o0> Vendor ID   (0x0000 ~ 0xFFFF) < 0x0000-0xFFFF>
        #define USB_VID                      0x0E6A
        //<o0> Product ID (0x0000 ~ 0xFFFF) < 0x0000-0xFFFF>
        #define USB_PID                      0x032A
        //<o0> Device release number (0x0000 ~ 0xFFFF) <0x0000-0xFFFF>
        #define USB_DID                      0x0100
        

        //<s> Manufacturer string descriptor.
        #define MANUFACTURER_DESCRIPTOR  "Megawin Technology Inc."

        //<s> Product string descriptor.
        #define PRODUCT_DESCRIPTOR        "USB Keyboard Controller With EasyPOD Mini"

        //<s0> Serial Number descriptor.
        #define SERIALNUMBER_DESCRIPTOR   "V1.00"

    //</h>
//</h>

// <<< end of Configuration section >>> 


const uint8_t USBD_EasyPODIN_bInterval  = 1;         /*!<Set EasyPOD Mini IN  interval.*/
const uint8_t USBD_EasyPODOUT_bInterval = 1;         /*!<Set EasyPOD Mini OUT interval.*/


/**
 *************************************************************************************************************
 * @fn       	DEVICE Descriptor  relationship 
 * @param    	No
 * @return      No
 * @details    	//-----------------USB 2.0------------------------------
				0: 		bLength 			Number		Size of this descriptor in bytes
				1: 		bDescriptorType		Constant	DEVICE Descriptor Type
				2,3: 	bcdUSB		    	BCD			USB specification release number in Binary-coded Decimal.
														This field identifies the release of the USB specification with
														which the device and its descriptors are compliant
				4:		bDeviceClass		Class		Class code:
														(1) If this field is reset to zero, each interface within a configuration 
															specifies its own class information and the various inerfaces operate
															independently
														(2) If this field is set to a value between 1 and 0xFE, the device supports 
															different class specifications on different interfaces and the 
															interfaces may not operate independently. This value identifies the 
															class definition used for the aggregate interfaces
														(3) If this field is set to 0xFF, the device class is vendor-specific
				5:      bDeviceSubClass 	Subclass	Subclass code
														(1) These codes are qualified by the value of the bDeviceClass field
														(2) If the bDeviceClass field is reset zero this field must alse be reset
															to zero.
														(3) If the bDeviceClass field is not set to 0xFF, all values are reserved 
															for assignment by the USB-IF.
				6:		bDeviceProtocol		Protocol    Protocol code
														(1) These codes are qualified by the value of the bDeviceSubClass fields.
															and the bDeviceSubClass field.
														(2) If a device supports class-specific protocols on a device basis  as 
															opposed to an interface basis, this code identifies the protocols 
															that the device uses as defined by the specification of the device class.
														(3) If this field is reset to zero, the device does not use class-specific 
															protocols on a device basis. However, it may use class-specific 
															protocols on an interface basis
														(4) If this field is set to 0xFF, the device uses a vendor-specific
															protocol on a device basis.
				7:		bMaxPacketSize0 	Number  	Maximum packet size for endpoint zero(only 8,16,32,or 64 are valid)
				8,9:    idVendor        	ID			VendorID(assigned by the USB-IF)
				10,11:  idProduct       	ID			Product ID(assigned by the manufacturer)
				12,13:  bcdDevice			BCD			Device release number in binary coded decimal
				14:     iManufacturer   	Index		Index of string descriptor describing manufacturer
				15:     iProduct        	Index 		Index of string descriptor describing product
				16:     iSerialNumber   	Index 		Index of string descriptor describing the device's serial number
				17:     bNumConfigurations	Number      Number of possible configurations
 **************************************************************************************************************
 */ 
const uint8_t USB_DEVICE_DESCRIPTOR[]=
{ 
    0x12,                                        // 0:  bLength
    DEVICE_DESCRIPTOR,                           // 1:  bDescriptorType (0x01 = Device)
    LOBYTE( dcdUSB ),                            //     bcdUSB(LSB)
    HIBYTE( dcdUSB ),                            //     bcdUSB(MSB)
    bDeviceClass,                                // 4:  bDeviceClass
    bDeviceSubClass,                             // 5:  bDevice SubClass
    bDeviceProtocol,                             // 6:  bDeviceProtocol
    0x40,                                        // 7:  bMaxPacketSize
    LOBYTE( USB_VID ),                           // 8:  idVendor(LSB)
    HIBYTE( USB_VID ),                           //     idVendor(MSB)
    LOBYTE( USB_PID ),                           // 10: idProduct(LSB)
    HIBYTE( USB_PID ),                           //     idProduct(MSB)
    LOBYTE( USB_DID ),                           // 12: bcdDevice(LSB)
    HIBYTE( USB_DID ),                           //     bcdDevice(MSB)
    
    0x01,                                        // 14: iManufacture (String Index)
    
    0x02,                                        // 15: iProduct     (String Index) 
    
    0x03,                                        // 16: iSerialNumber(String Index)
    
    0x01                                         // 17: bNumConfigurations
};

//-----MANUFACTURER(UNICODE) in String Descriptor-----//
const uint8_t Manufacturer_Descriptor[] = 
{
    MANUFACTURER_DESCRIPTOR,
};


//-----PRODUCT(UNICODE) in String Descriptor-----//
const uint8_t Product_Descriptor[] = 
{ 
    PRODUCT_DESCRIPTOR
};



//-----Serial Number in String Descriptor-----//
const uint8_t SerialNumber_Descriptor[] = 
{ 
    SERIALNUMBER_DESCRIPTOR
};



#define MFS_LEN (sizeof(MANUFACTURER_DESCRIPTOR)*2)        /*!< Manufacture descriptor size.*/
#define PDS_LEN (sizeof(PRODUCT_DESCRIPTOR)*2)             /*!< Product descriptor size.*/
#define SNS_LEN (sizeof(SERIALNUMBER_DESCRIPTOR)*2)        /*!< Serial number descriptor size.*/



const uint8_t MFS_LENn = MFS_LEN;
const uint8_t PDS_LENn = PDS_LEN;                                     
const uint8_t SNS_LENn = SNS_LEN;  










